# Guía de Automatización de Cajas y Tasas

## 📋 Resumen

Este sistema automatiza la gestión de cajas y tasas de cambio con las siguientes características:

- **Cortes de caja automáticos**: A las 1:00 PM y 6:00 PM
- **Verificación de tasas**: Desde las 12:00 AM hasta las 2:00 PM
- **Actualización automática de tasas**: A las 2:30 PM
- **Dashboard administrativo**: Monitoreo en tiempo real
- **Widget de estado**: Para incluir en otras vistas

## 🚀 Comandos Disponibles

### 1. Verificar Estado del Sistema
```bash
php artisan cajatasa:verificar-estado
php artisan cajatasa:verificar-estado --empresa=1
```

### 2. Ejecutar Automatización Completa
```bash
php artisan cajatasa:automatizar
php artisan cajatasa:automatizar --force
```

### 3. Actualizar Tasa Programada
```bash
php artisan tasa:actualizar-programada
php artisan tasa:actualizar-programada --force
```

### 4. Corte de Caja Automático
```bash
php artisan caja:corte-automatico
php artisan caja:corte-automatico --force
```

### 5. Probar Sistema Completo
```bash
# Modo simulación (recomendado)
php artisan cajatasa:probar-sistema

# Modo real (ejecuta cambios)
php artisan cajatasa:probar-sistema --modo=real

# Simular hora específica
php artisan cajatasa:probar-sistema --hora=14:30
```

## 📊 Dashboard Administrativo

### Acceso
- URL: `/admin/cajas-tasa/dashboard`
- Requiere permisos de administrador

### Funcionalidades
1. **Estado en tiempo real**: Visualización del estado actual del sistema
2. **Acciones rápidas**: Botones para ejecutar operaciones manualmente
3. **Filtros por empresa y sucursal**: Personalizar la vista
4. **Estadísticas**: Métricas del sistema
5. **Historial de tasas**: Últimas tasas registradas

## 🎯 Widget de Estado

### Inclusión en otras vistas
```blade
@livewire('admin.cajas.caja-tasa-status-widget')
```

### Características
- Estado compacto del sistema
- Acciones rápidas integradas
- Auto-actualización cada 5 minutos
- Responsive y adaptable

## ⚙️ Configuración de Horarios

Los horarios están definidos en `CajaTasaConfigService.php`:

```php
const CORTE_CAJA_HORARIOS = ['13:00', '18:00'];
const TASA_VERIFICACION_INICIO = '00:00';
const TASA_VERIFICACION_FIN = '14:00';
const TASA_ACTUALIZACION_AUTO = '14:30';
```

## 🔧 Tareas Programadas (Cron Jobs)

El sistema incluye las siguientes tareas programadas:

```php
// Cada 30 minutos - Automatización completa
$schedule->command('cajatasa:automatizar')->everyThirtyMinutes();

// Diariamente a las 2:30 PM - Actualización de tasa
$schedule->command('tasa:actualizar-programada')->dailyAt('14:30');

// Diariamente a las 1:00 PM y 6:00 PM - Corte de caja
$schedule->command('caja:corte-automatico')->dailyAt('13:00');
$schedule->command('caja:corte-automatico')->dailyAt('18:00');

// Cada hora entre 12 AM y 2 PM - Verificación de tasas
$schedule->command('exchange:fetch')->hourly()->between('0:00', '14:00');
```

## 🎨 Mejoras Implementadas

### 1. Middleware Optimizado
- Lógica simplificada
- Uso de caché para mejorar rendimiento
- Manejo mejorado de errores

### 2. Servicios Especializados
- `CajaTasaConfigService`: Gestión de configuración
- `CajaTasaAutomationService`: Lógica de automatización
- Separación de responsabilidades

### 3. Sistema de Monitoreo
- Dashboard administrativo completo
- Widget de estado para integración
- Comandos de verificación

### 4. Testing y Debugging
- Comando de prueba con simulación
- Modo real y simulación
- Verificación de integridad de datos

## 🚨 Manejo de Errores

### Escenarios Comunes

1. **Sin tasa del día**
   - El sistema intentará obtenerla automáticamente
   - Se notificará al administrador

2. **Sin cajas abiertas**
   - Se crearán automáticamente si es necesario
   - Se verificará la configuración

3. **Errores de conexión con API de tasas**
   - Se reintentará en el próximo ciclo
   - Se registrará en los logs

4. **Conflictos de horarios**
   - Se priorizan las operaciones críticas
   - Se ejecutan en orden de importancia

## 📈 Métricas y Estadísticas

### Métricas Disponibles
- Número de cajas abiertas/cerradas
- Tasas promedio por período
- Tiempo de respuesta del sistema
- Frecuencia de errores

### Logs y Auditoría
- Todos los cambios se registran
- Logs detallados de operaciones
- Trazabilidad completa

## 🔒 Seguridad

### Permisos Requeridos
- `access admin panel`: Para acceder al dashboard
- `manage exchange rates`: Para modificar tasas
- `manage cajas`: Para operaciones de caja

### Validaciones
- Verificación de permisos en cada operación
- Validación de datos de entrada
- Protección contra operaciones duplicadas

## 🚀 Optimización de Rendimiento

### Caché
- Estado del sistema en caché por 5 minutos
- Tasas en caché temporal
- Reducción de consultas a base de datos

### Índices de Base de Datos
- Índices en campos de búsqueda frecuente
- Optimización de consultas complejas
- Mantenimiento de índices

## 📞 Soporte y Mantenimiento

### Comandos de Mantenimiento
```bash
# Limpiar caché del sistema
php artisan cache:clear

# Verificar integridad
php artisan cajatasa:probar-sistema --modo=real

# Forzar actualización
php artisan cajatasa:automatizar --force
```

### Monitoreo Recomendado
- Verificar logs diariamente
- Monitorear dashboard administrativo
- Revisar métricas de rendimiento
- Actualizar tasas manualmente si es necesario

## 🎯 Próximas Mejoras Sugeridas

1. **Notificaciones en tiempo real**
   - Integración con WhatsApp/Telegram
   - Alertas de errores críticos
   - Resúmenes diarios por email

2. **Análisis predictivo**
   - Predicción de necesidades de cambio
   - Análisis de tendencias
   - Recomendaciones automáticas

3. **Integración con APIs externas**
   - Múltiples fuentes de tasas
   - Fallback automático
   - Validación cruzada

4. **Dashboard móvil**
   - App para administradores
   - Notificaciones push
   - Acceso remoto

## 📞 Contacto y Soporte

Para problemas o consultas:
1. Verificar los logs en `storage/logs/laravel.log`
2. Ejecutar comandos de diagnóstico
3. Revisar el dashboard administrativo
4. Contactar al equipo de desarrollo

---

**Última actualización**: {{date}}  
**Versión**: 1.0.0